#!/usr/bin/perl

# Identify the distro, accounting for slackware.
if (-e "/etc/slackware-version") 
 { open(ISSFILE,"/etc/slackware-version"); }
else 
 { open(ISSFILE,"/etc/issue") || die "Tried to open /etc/issue to guess your system type, but failed"; }

my $aline=<ISSFILE>;

close ISSFILE;

my $pattype="";
my $inittype="";
my $confpath="";
my $exepath="";
my $initname="";
my $logconf="";

if(  $aline =~ /Red Hat Enterprise Linux ES release 4/ )
 {
   printf "System type: RH Enterprise\n";
   $pattype="rhFC30";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
 } elsif (  $aline =~ /Fedora Core release 2 / ) {
   printf "System type: Fedora Core 2, post RH9.0, but not FC3 or FC4\n";
   $pattype="rh7390";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
 } elsif (  $aline =~ /Fedora Core release 4 / ) {
   printf "System type: Fedora Core 4\n";
   $pattype="rhFC30";
   $inittype="rhFC40";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/logwatch/conf/";
   $logserv="/etc/logwatch/scripts/";
 } elsif(  $aline =~ /Fedora/ ) {
   printf "System type: Fedora, post RH9.0 and post Fedora Core 2\n";
   $pattype="rhFC30";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
 } elsif (  $aline =~ /Red Hat/ ) {
   printf "System type: RedHat, pre Fedora\n";
   $pattype="rh7390";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
 } elsif (  $aline =~ /Debian/ ) {
   printf "System type: Debian system\n";
   $pattype="deb31";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/local/sbin/";
   $initname="ssh";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/usr/share/logwatch/scripts/services/";
 } elsif (  $aline =~ / SUSE / ) {
   printf "System type: SUSE system\n";
   $pattype="su10rc1";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/local/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/usr/share/logwatch/scripts/services/";
 } elsif (  $aline =~ /entoo / ) {
   printf "System type: Gentoo system\n";
   $pattype="su10rc1";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/usr/share/logwatch/scripts/services/";
} elsif (  $aline =~ /CentOS 3\./ ) {
   printf "System type: CentOS 3.x\n";
   $pattype="rhFC30";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
} elsif (  $aline =~ /CentOS / ) {
   printf "System type: CentOS 4.x\n";
   $pattype="rh7390";
   $inittype="$pattype";
   $confpath="/etc/";
   $exepath="/usr/sbin/";
   $initname="sshd";
   $logconf="/etc/log.d/conf/services/";
   $logserv="/etc/log.d/scripts/services/";
} elsif ($aline =~ /Slackware/) {
   printf "System type: Slackware Linux\n";
   $pattype = "su10rc1";
   $inittype = "slackware";
   $confpath = "/etc";
   $exepath = "/usr/sbin";
   $initname = "sshd";
   $logconf="/etc/log.d/conf/services";
   $logserv="/etc/log.d/scripts/services";
 } else {
   printf "System type does not appear to be Fedora, RedHat pre Fedora, Debian, \n";
   printf "CentOS, SUSE, RH Enterprise, Gentoo or Slackware. So, you will have to install manually \n";
   printf "(see INSTALL) and send me some hints on how to identify your system.\n";
   exit 1;
 }


printf "configuration path: $confpath.\n";
printf "exepath: $exepath.\n";
if( -f "$exepath/sshdfilterrc" ) {
   printf "Not installing configuration file, already exists.\n";
} else {
   printf "Installing configuration file sshdfilterrc.\n";
   system("cat etc/sshdfilterrc patterns/$pattype.partconf > /etc/sshdfilterrc");
   system("chmod 644 /etc/sshdfilterrc");
}

printf "Installing man pages to /usr/share/man/man{1,5}\n";
system("install -m 644 man/sshdfilter.1 /usr/share/man/man1/");
system("install -m 644 man/sshdfilterrc.5 /usr/share/man/man5/");

printf "Installing sshdfilter script.\n";
system("install -m 744 source/sshdfilter.pl $exepath/sshdfilter");

if ($inittype eq "slackware") {
   printf "Patching your startup script in /etc/rc.d\n";
   if( ! -f "/etc/rc.d/$initname.orig" ) {
      system("cp /etc/rc.d/$initname /etc/rc.d/$initname.orig");
      system("chmod 644 /etc/rc.d/$initname.orig");
   }
   system("(cd /etc/rc.d ; patch -l -N -b ) < etc/init.d/rc.$initname.patch");
} else {
   printf "Patching your startup script in /etc/init.d/.\n";
   if( ! -f "/etc/init.d/$initname.orig" ) { 
      system("cp /etc/init.d/$initname /etc/init.d/$initname.orig"); 
   }
   system("(cd /etc/init.d/ ; patch -l -N -b ) < etc/init.d/$initname.$inittype.patch");
}

#if ( -d "$logconf" ) {
#   printf "LogWatch directory found, installing LogWatch scripts.\n";
#   system("install -m 644 etc/log.d/conf/services/sshdfilt.conf $logconf/");
#   system("install -m 644 etc/log.d/scripts/services/sshdfilt $logserv/");
#   printf "Modifying $logconf/secure.conf.\n";
#   if( ! -f "$logconf/secure.conf.orig" ) {
#      system("cp $logconf/secure.conf $logconf/secure.conf.orig");
#   }
#   system("sed \"s/ sshdfilt//g;s/ sshd/ sshd sshdfilt/g;\" < $logconf/secure.conf > /tmp/sshdfilt.inst");
#   system("install -m 644 /tmp/sshdfilt.inst $logconf/secure.conf");
#}

printf "Assuming that all worked, read INSTALL for the final steps.\n";
printf "If not, you will have to install manually by reading INSTALL in full,\n";
printf "this script followed route 1, sshd wrapper, not route 2, standalone.\n";


